<x-user.content>
    <x-slot:title>eCommerce MM</x-slot:title>
    <x-slot:head>
        <style>
            /* Bootstrap 5 CSS and icons included */
            :root {
                --colorPrimaryNormal: #00b3bb;
                --colorPrimaryDark: #00979f;
                --colorPrimaryGlare: #00cdd7;
                --colorPrimaryHalf: #80d9dd;
                --colorPrimaryQuarter: #bfecee;
                --colorPrimaryEighth: #dff5f7;
                --colorPrimaryPale: #f3f5f7;
                --colorPrimarySeparator: #f3f5f7;
                --colorPrimaryOutline: #dff5f7;
                --colorButtonNormal: #00b3bb;
                --colorButtonHover: #00cdd7;
                --colorLinkNormal: #00979f;
                --colorLinkHover: #00cdd7;
            }

            /* body {
                margin: 24px;
            } */


            .upload_dropZone {
                color: #0f3c4b;
                background-color: var(--colorPrimaryPale, #c8dadf);
                outline: 2px dashed var(--colorPrimaryHalf, #c1ddef);
                outline-offset: -12px;
                transition:
                    outline-offset 0.2s ease-out,
                    outline-color 0.3s ease-in-out,
                    background-color 0.2s ease-out;
            }

            .upload_dropZone.highlight {
                outline-offset: -4px;
                outline-color: var(--colorPrimaryNormal, #0576bd);
                background-color: var(--colorPrimaryEighth, #c8dadf);
            }

            .upload_svg {
                fill: var(--colorPrimaryNormal, #0576bd);
            }

            .btn-upload {
                color: #fff;
                background-color: var(--colorPrimaryNormal);
            }

            .btn-upload:hover,
            .btn-upload:focus {
                color: #fff;
                background-color: var(--colorPrimaryGlare);
            }

            .upload_img {
                width: calc(33.333% - (2rem / 3));
                object-fit: contain;
            }

            .upload_gallery img {
                width: 70%;
            }
        </style>

    </x-slot:head>
    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-12">
                <nav class="breadcrumb bg-light mb-30">
                    <a class="breadcrumb-item text-dark" href="/">Home</a>
                    <span class="breadcrumb-item active">Checkout</span>
                </nav>
            </div>
        </div>
    </div>

    <div class="container-fluid">
        <div class="row px-xl-5">
            <div class="col-lg-8">
                <x-message></x-message>
                <h5 class="section-title position-relative text-uppercase mb-3"><span class="bg-secondary pr-3">Tagihan
                        Pembelian
                    </span></h5>
                <div class="bg-light p-30 mb-5">
                    <div class="card">
                        <div class="card-header d-flex justify-content-between">
                            <span class="text-danger">Unpaid </span>
                            <span><i class="fa fa-print"></i></span>
                        </div>
                        <div class="card-body">
                            <div class=" d-flex justify-content-center">
                                <h3>INVOICE : {{ $t->kd_transaksi }}</h3>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <table style="width: 100%">
                                        <tr>
                                            <td width="15%">Kepada</td>
                                            <td width="2%">:</td>
                                            <td>{{ $t->member->nm_member }}</td>
                                        </tr>
                                        <tr>
                                            <td>No Hp</td>
                                            <td>:</td>
                                            <td>{{ $t->member->hp_member }}</td>
                                        </tr>
                                        <tr>
                                            <td>Alamat</td>
                                            <td>:</td>
                                            <td>{{ ongkir($t->member_id)->alamat }}</td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6 mb-3 ">
                                    <table style="width: 100%">
                                        <tr>
                                            <td width="22%">Invoice</td>
                                            <td width="6%">:</td>
                                            <td class="pl-2"> #{{ $t->kd_transaksi }}</td>
                                        </tr>
                                        <tr>
                                            <td>Tanggal</td>
                                            <td>:</td>
                                            <td class="pl-2">{{ tgl_time($t->created_at) }}</td>
                                        </tr>
                                        <tr>
                                            <td>Status</td>
                                            <td>:</td>
                                            <td class="pl-2">{{ $t->sts_antar == 'Y' ? 'Diantar' : 'Ambil Sendiri' }}
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            <div class="table-responsive">
                                <table class="table  table-bordered table-sm  text-center mb-0">
                                    <thead>
                                        <tr>
                                            <th>Produk</th>
                                            <th>Harga</th>
                                            <th>Qty</th>
                                            <th>Jumlah</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($keranjang as $k)
                                            <tr>
                                                <td class="text-left">{{ $k->produk->nm_produk }}</td>
                                                <td class="text-right">{{ number_format($k->harga, 0, ',', '.') }}.00
                                                </td>
                                                <td>{{ number_format($k->jumlah, 0, ',', '.') }}</td>
                                                <td class="text-right">
                                                    {{ number_format($k->harga * $k->jumlah, 0, ',', '.') }}.00</td>
                                            </tr>
                                        @endforeach
                                        <tr>
                                            <td colspan="3">Subtotal</td>
                                            <td class="text-right">{{ number_format($t->jumlah, 0, ',', '.') }}.00</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>

                <div class="collapse mb-5" id="shipping-address">
                    <h5 class="section-title position-relative text-uppercase mb-3"><span
                            class="bg-secondary pr-3">Alamat</span></h5>
                    <div class="bg-light p-30">
                        <form action="">
                            <div class="row">
                                <div class="col-md-12 form-group">
                                    <label>Alamat Lengkap : Nama jalan, Gang / Perumahan Dll</label>
                                    <textarea name="" id="" cols="30" class="form-control" rows="9"></textarea>
                                </div>
                                <button class="btn btn-block btn-primary font-weight-bold py-3">Kirim Alamat
                                    Baru</button>
                            </div>
                        </form>
                    </div>
                </div>


            </div>


            <div class="col-lg-4">
                <h5 class="section-title position-relative text-uppercase mb-3"><span class="bg-secondary pr-3">Total

                    </span></h5>
                <div class="bg-light p-30 mb-5">
                    <div class="border-bottom">

                        <div class="d-flex justify-content-between">
                            <p>Subtotal</p>
                            <p>{{ number_format($t->jumlah, 0, ',', '.') }}.00</p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <p>Diskon</p>
                            <p>{{ number_format($t->diskon, 0, ',', '.') }}%</p>
                        </div>
                        <div class="d-flex justify-content-between">
                            <p>Ongkir</p>
                            <p>{{ number_format($t->ongkir, 0, ',', '.') }}.00</p>
                        </div>

                    </div>
                    <div class="pt-2">
                        <div class="d-flex justify-content-between mt-2">
                            <h5>Total</h5>
                            <h5> {{ number_format($t->total, 0, ',', '.') }}.00</h5>
                        </div>
                    </div>
                    <hr>
                    @php
                        $tgl = date('Y-m-d H:i:s');
                        $tgl_expired = strtotime($p->expired);
                        $tgl_sekarang = strtotime($tgl);
                        $expired = $tgl_sekarang - $tgl_expired;
                    @endphp

                    <div class="text-center">
                        @if ($expired > 0)
                        @else
                            Pembayaran Via <br> {{ $d->judul }} <br> No. {{ $d->isi }} a.n
                            {{ $d->link }}
                        @endif
                        <hr>
                        Pembayaran dibatasi sampai 10 Menit, <br> dimulai dari Proses Kirim Pesanan, Pastikan
                        sertakan
                        <br>
                        <b> NO INVOICE#{{ $t->kd_transaksi }}</b> <br>
                        saat
                        pembayaran
                        <br>
                        @php
                            $wktu = date($t->created_at, time() + 60 * 15);
                        @endphp
                        @if ($p->sts_transfer == 'N')
                            <div class="mt-1">
                                <span id="demo"
                                    style="background-color: rgb(165, 31, 31); padding: 5px; padding-left: 10px; padding-right: 10px; color: white; font: 600"></span>
                            </div>
                        @endif
                        Apabila dalam kurun waktu yang di tentukan belum melakukan pembayaran, Transaksi di anggap
                        batal
                        <br>
                        <br>
                        Jika sudah melakukan pembayaran silahkan Upload Foto Struk Pembayaran di bawah!


                    </div>

                </div>

            </div>


            @if ($expired > 0)
            @else
                <div class="col-lg-12">
                    <h5 class="section-title position-relative text-uppercase mb-3"><span
                            class="bg-secondary pr-3">Upload
                            Foto
                            Pembayaran
                        </span></h5>
                    <div class="bg-light p-30 mb-5">
                        <div class="row d-flex justify-content-center">
                            <div class="col-md-6">
                                <div class="row">
                                    <button class="btn btn-dark btn-block upload" data-toggle="collapse"
                                        data-target="#upload">Upload Struk Pembayaran</button>
                                </div>



                                <div class="collapse mb-5 show" id="upload">
                                    <div class="bg-light p-30">
                                        {{-- <form action="" method="post" enctype="multipart/form-data">
                                        <div class="row">
                                            <div class="col-md-12 form-group">
                                                <label>Cari Struk</label>
                                                <input type="file" name="" id="exampleInputFile"
                                                    class="form-control mb-2">
                                                <div style="height: 200px; border: 1px solid rgb(185, 180, 180)"
                                                    class="gambar"></div>
                                            </div>
                                            <button class="btn btn-block btn-primary font-weight-bold py-3">Kirim
                                                Struk
                                                Pembayaran</button>
                                        </div>
                                    </form> --}}


                                        <form method="post" action="{{ route('bukti.transfer') }}"
                                            enctype="multipart/form-data">
                                            @csrf
                                            <input type="hidden" name="id" id=""
                                                value="{{ $p->id }}">
                                            <input type="hidden" name="kode" value="{{ $t->kd_transaksi }}">

                                            <div class="upload_dropZone text-center mb-3 p-4">
                                                <svg class="upload_svg" width="60" height="60"
                                                    aria-hidden="true">
                                                    <use href="#icon-imageUpload"></use>
                                                </svg>

                                                <p class="small my-2">Drag &amp; Drag & Drop logo image inside dashed
                                                    region
                                                    or<br><i>or</i></p>

                                                <input id="upload_image_background" class="position-absolute invisible"
                                                    name="struk" type="file" style="width: 50%"
                                                    accept="image/jpeg, image/png, image/svg+xml" required />

                                                <label class="btn btn-upload mb-3"
                                                    for="upload_image_background">Choose
                                                    file</label>

                                                <div
                                                    class="upload_gallery d-flex flex-wrap justify-content-center gap-3 mb-0">
                                                </div>

                                            </div>
                                            <button class="btn btn-block btn-primary font-weight-bold py-3">
                                                Kirim Struk Pembayaran</button>
                                        </form>

                                    </div>
                                </div>




                            </div>
                        </div>
                    </div>
                </div>
            @endif


        </div>
    </div>

    <input type="hidden" name="" id="tgl" value="{{ $p->expired }}">


    <x-slot:foot>
        <script>
            $("#exampleInputFile").change(function() {
                filePreview(this);
            });

            function filePreview(input) {
                if (input.files && input.files[0]) {
                    var reader = new FileReader();
                    reader.onload = function(e) {
                        $('#img').remove();
                        $('.gambar').append('<img src="' + e.target.result +
                            '" width="100%" height="180px" id="img">');
                    };
                    reader.readAsDataURL(input.files[0]);
                }
            }

            $('.upload').click(function() {
                $('#cameraq').removeClass('show');
            })
        </script>
        <script>
            // Set the date we're counting down to
            // var id = {{ $d->id }};
            var tgl = $('#tgl').val();
            var countDownDate = new Date(tgl).getTime();

            // Update the count down every 1 second
            var x = setInterval(function() {

                // Get today's date and time
                var now = new Date().getTime();

                // Find the distance between now and the count down date
                var distance = countDownDate - now;

                // Time calculations for days, hours, minutes and seconds
                var days = Math.floor(distance / (1000 * 60 * 60 * 24));
                var hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                var minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                var seconds = Math.floor((distance % (1000 * 60)) / 1000);

                // Output the result in an element with id="demo"
                // document.getElementById("demo").innerHTML = days + " Hari " + hours + " : " +
                //     minutes + " : " + seconds + "  ";
                document.getElementById("demo").innerHTML =
                    minutes + " : " + seconds + "  ";

                // If the count down is over, write some text 
                if (distance < 0) {
                    clearInterval(x);
                    document.getElementById("demo").innerHTML = "EXPIRED";
                }
            }, 1000);
        </script>
        <script>
            console.clear();
            ('use strict');


            // Drag and drop - single or multiple image files
            // https://www.smashingmagazine.com/2018/01/drag-drop-file-uploader-vanilla-js/
            // https://codepen.io/joezimjs/pen/yPWQbd?editors=1000
            (function() {

                'use strict';

                // Four objects of interest: drop zones, input elements, gallery elements, and the files.
                // dataRefs = {files: [image files], input: element ref, gallery: element ref}

                const preventDefaults = event => {
                    event.preventDefault();
                    event.stopPropagation();
                };

                const highlight = event =>
                    event.target.classList.add('highlight');

                const unhighlight = event =>
                    event.target.classList.remove('highlight');

                const getInputAndGalleryRefs = element => {
                    const zone = element.closest('.upload_dropZone') || false;
                    const gallery = zone.querySelector('.upload_gallery') || false;
                    const input = zone.querySelector('input[type="file"]') || false;
                    return {
                        input: input,
                        gallery: gallery
                    };
                }

                const handleDrop = event => {
                    const dataRefs = getInputAndGalleryRefs(event.target);
                    dataRefs.files = event.dataTransfer.files;
                    handleFiles(dataRefs);
                }


                const eventHandlers = zone => {

                    const dataRefs = getInputAndGalleryRefs(zone);
                    if (!dataRefs.input) return;

                    // Prevent default drag behaviors
                    ;
                    ['dragenter', 'dragover', 'dragleave', 'drop'].forEach(event => {
                        zone.addEventListener(event, preventDefaults, false);
                        document.body.addEventListener(event, preventDefaults, false);
                    });

                    // Highlighting drop area when item is dragged over it
                    ;
                    ['dragenter', 'dragover'].forEach(event => {
                        zone.addEventListener(event, highlight, false);
                    });;
                    ['dragleave', 'drop'].forEach(event => {
                        zone.addEventListener(event, unhighlight, false);
                    });

                    // Handle dropped files
                    zone.addEventListener('drop', handleDrop, false);

                    // Handle browse selected files
                    dataRefs.input.addEventListener('change', event => {
                        dataRefs.files = event.target.files;
                        handleFiles(dataRefs);
                    }, false);

                }


                // Initialise ALL dropzones
                const dropZones = document.querySelectorAll('.upload_dropZone');
                for (const zone of dropZones) {
                    eventHandlers(zone);
                }


                // No 'image/gif' or PDF or webp allowed here, but it's up to your use case.
                // Double checks the input "accept" attribute
                const isImageFile = file => ['image/jpeg', 'image/png', 'image/svg+xml'].includes(file.type);


                function previewFiles(dataRefs) {
                    if (!dataRefs.gallery) return;
                    for (const file of dataRefs.files) {
                        let reader = new FileReader();
                        reader.readAsDataURL(file);
                        reader.onloadend = function() {
                            let img = document.createElement('img');
                            img.className = 'upload_img mt-2';
                            img.setAttribute('alt', file.name);
                            img.src = reader.result;
                            dataRefs.gallery.appendChild(img);
                        }
                    }
                }

                // Based on: https://flaviocopes.com/how-to-upload-files-fetch/
                // const imageUpload = dataRefs => {

                //     // Multiple source routes, so double check validity
                //     if (!dataRefs.files || !dataRefs.input) return;

                //     const url = dataRefs.input.getAttribute('data-post-url');
                //     if (!url) return;

                //     const name = dataRefs.input.getAttribute('data-post-name');
                //     if (!name) return;

                //     const formData = new FormData();
                //     formData.append(name, dataRefs.files);

                //     fetch(url, {
                //             method: 'POST',
                //             body: formData
                //         })
                //         .then(response => response.json())
                //         .then(data => {
                //             console.log('posted: ', data);
                //             if (data.success === true) {
                //                 previewFiles(dataRefs);
                //             } else {
                //                 console.log('URL: ', url, '  name: ', name)
                //             }
                //         })
                //         .catch(error => {
                //             console.error('errored: ', error);
                //         });
                // }


                // Handle both selected and dropped files
                const handleFiles = dataRefs => {

                    let files = [...dataRefs.files];

                    // Remove unaccepted file types
                    files = files.filter(item => {
                        if (!isImageFile(item)) {
                            console.log('Not an image, ', item.type);
                        }
                        return isImageFile(item) ? item : null;
                    });

                    if (!files.length) return;
                    dataRefs.files = files;

                    previewFiles(dataRefs);
                    imageUpload(dataRefs);
                }

            })();
        </script>
    </x-slot:foot>
</x-user.content>
